/* All user scripts should derive from the base "Application" class */

require ("Application");
//OPC Support is used to add the items to the DataHub configuration file.
require ("OPCSupport");


class BridgeCreator Application
{
	//The name of the file to read
	filename = "C:\\Program Files\\Cogent\\Cogent DataHub\\scripts\\DDETagList.csv";
	
	//this tag is our File Pointer once the file is opened
	fp;
}

method BridgeCreator.readFile()
{
	//local		myConnection = new OPCConnection();
	
	//we open the file here.  If you want to change the path of where
	//the file is you would do that here.
	if ((fp = open(.filename, "r", nil)) != nil);
	{
		//create some local variables 
		local line;
		local count = 0;
			
		//add variables to hold the Connection Name, DDE ItemID
		//DataHub Point Name and Data Domain
		local connectionName;
		local opcItemID;
		local dhPointName;
		local dataDomain;
		
		local lineArray;
		//loop until we have read the entire file.
		while((line = read_line(fp)) != _eof_)
		{
			//if we are at the beginning of the file we want to skip
			//of the header and read the second line.
			if(count == 0)
			{
				line = read_line(fp);
				count++;
			}
			
			//split the comma separated line we read in and place it
			//into an array
			lineArray = list_to_array(string_split(line, ",", 0));
				
			//set the Connection Name from the CSV File
			connectionName = lineArray[0];
			
			//set the DDE itemID
			opcItemID = lineArray[1];
			
			//set the tag name for the internal OPC DataHub tag
			dhPointName = lineArray[2];
			
			//the seperator will be used to break down a tag name heirarchically
			dataDomain = lineArray[3];
			
			datahub_command(format("(DDEAdvise %s %s %s %s)", connectionName,opcItemID,dhPointName,dataDomain));
		}
		
		//once we have read the entire file we need to close the file.
		close(fp);
	}
}


/* The constructor will start when the script is loaded. */
method BridgeCreator.constructor ()
{	
	//call the readFile() method that will read the file and create
	//all the tags
	.readFile();
	
}

/* Any code to be run when the program gets shut down. */
method BridgeCreator.destructor ()
{
}

/* Start the program by instantiating the class.  If your constructor
 * code does not create a persistent reference to the instance (self),
 * then it will be destroyed by the garbage collector soon after
 * creation.  If you do not want this to happen, assign the instance
 * to a global variable, or create a static data member in your class
 * to which you assign 'self' during the construction process.
 * ApplicationSingleton() does this for you automatically. */
ApplicationSingleton (BridgeCreator);
